%Returns the parameters to be used for Differential Evolution in
%hippocampus localization

function options = get_localization_de_params(verbose, n_points)
    options.I_NP         = 64;
    options.F_weight     = 0.7;
    options.F_CR         = 0.9;
    options.I_D          = n_points*2;
    options.FVr_minbound = 0;
    options.FVr_maxbound = 1;
    options.I_bnd_constr = 1;
    options.I_itermax    = 200;
    options.F_VTR        = -(5*n_points + 20*(n_points-1));
    options.I_strategy   = 2; %2 = local-to-best
    if verbose > 0
        options.I_refresh    = 10;
    else
        options.I_refresh    = 0;
    end
    options.I_plotting   = 0;
end